#ifndef COMMON_HPP
#define COMMON_HPP

#include <memory>
#include <iostream>
#include <sstream>
#include <iomanip>
#include <vector>
#include <iterator>
#include <fstream>
#ifdef ERRORHANDLER
#include <execinfo.h>
#endif

#include "../probi-source/DatastreamCoreset.hpp"
#include "../probi-source/EuclideanMetric.hpp"
#include "../probi-source/EuclideanNorm.hpp"
#include "../probi-source/FastCoreset.hpp"
#include "../probi-source/PKMedian.hpp"
#include "../probi-source/LloydMedian.hpp"
#include "../probi-source/LloydProbMedian.hpp"
#include "../probi-source/Weiszfeld.hpp"
#include "../probi-source/WeightedPoint.hpp"
#include "../probi-source/Point.hpp"
#include "../probi-source/ProbabilisticPoint.hpp"

#include <boost/algorithm/string.hpp>

#ifdef ERRORHANDLER
void handler();
#endif

void processStream(std::fstream & fs, std::function<bool(ProbabilisticPoint) > processProbPoint, std::string splitSeq, int numOfPointsToMerge, double prob, bool withWeights);

#endif
