using namespace std;

#include "common.hpp"

#ifdef ERRORHANDLER
void handler()
{
    void *trace_elems[20];
    int trace_elem_count(backtrace(trace_elems, 20));
    char **stack_syms(backtrace_symbols(trace_elems, trace_elem_count));
    for (int i = 0; i < trace_elem_count; ++i)
    {
        std::cout << stack_syms[i] << "\n";
    }
    free(stack_syms);

    exit(1);
}
#endif

void processStream(std::fstream & fs, std::function<bool(ProbabilisticPoint) > processProbPoint, std::string splitSeq, int numOfPointsToMerge, double prob, bool withWeights)
{
    std::vector<WeightedPoint> pointBuffer;
    pointBuffer.reserve(numOfPointsToMerge);
    double weight = 1;
    std::string line;
    int pos = 0;
    int dim = 0;
    int pointsPerLine = numOfPointsToMerge + (withWeights ? 1 : 0);
    while (std::getline(fs, line))
    {
        if(withWeights && pos % pointsPerLine == 0)
        {
          weight = atof(line.c_str());
        }
        else
        {
          std::vector<std::string> stringcoords;
          boost::split(stringcoords, line, boost::is_any_of(splitSeq));

          std::vector<double> coords;
          coords.reserve(stringcoords.size());
          for (size_t i = 0; i < stringcoords.size(); ++i)
              coords.push_back(atof(stringcoords[i].c_str()));
          WeightedPoint p(coords, prob);

          if (dim == 0)
              dim = p.getDimension();

          if (p.getDimension() != dim)
              continue;
          else
              pointBuffer.push_back(p);
        }

        ++pos;
        if (pos % pointsPerLine == 0)
        {
          ProbabilisticPoint pp(pointBuffer);
          if (withWeights)
            pp.setWeight(weight);
          bool contin = processProbPoint(pp);
          if (!contin)
            return;
          pointBuffer.clear();
        }
    }
}
